/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.api.data;

import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_4844;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.data.ILootrInfo;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class SimpleLootrInstance {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected class_2371<class_1799> items;
    protected class_2371<class_1799> referenceInventory = null;
    protected final Set<UUID> clientOpeners = new ObjectOpenHashSet();
    protected UUID infoId = null;
    protected boolean hasBeenOpened = false;
    protected String cachedId;
    protected boolean clientOpened = false;
    protected boolean providesOwnUuid = false;
    protected final Supplier<Set<UUID>> visualOpenersSupplier;

    public SimpleLootrInstance(Supplier<Set<UUID>> visualOpenersSupplier, int size) {
        this.items = class_2371.method_10213((int)size, (Object)class_1799.field_8037);
        this.visualOpenersSupplier = visualOpenersSupplier;
    }

    public class_2371<class_1799> getItems() {
        return this.items;
    }

    public void setReferenceInventory(class_2371<class_1799> items) {
        this.referenceInventory = items;
    }

    public class_2371<class_1799> getReferenceInventory() {
        return this.referenceInventory;
    }

    public Set<UUID> getClientOpeners() {
        return this.clientOpeners;
    }

    public boolean isClientOpened() {
        return this.clientOpened;
    }

    public void setClientOpened(boolean opened) {
        this.clientOpened = opened;
    }

    @NotNull
    public UUID getInfoUUID() {
        if (this.providesOwnUuid) {
            throw new IllegalStateException("This instance provides its own UUID but hasn't overriden `getInfoUUID`: " + String.valueOf(this));
        }
        if (this.infoId == null) {
            this.infoId = UUID.randomUUID();
        }
        return this.infoId;
    }

    public String getInfoKey() {
        if (this.cachedId == null) {
            this.cachedId = ILootrInfo.generateInfoKey(this.getInfoUUID());
        }
        return this.cachedId;
    }

    public boolean hasBeenOpened() {
        return this.hasBeenOpened;
    }

    public int getInfoContainerSize() {
        return this.items.size();
    }

    public void setHasBeenOpened() {
        this.hasBeenOpened = true;
    }

    public void loadAdditional(class_11368 input) {
        if (!this.providesOwnUuid) {
            this.infoId = input.method_71426("LootrId", class_4844.field_25122).orElse(null);
        }
        this.hasBeenOpened = input.method_71433("LootrHasBeenOpened", false);
        if (this.infoId == null && !this.providesOwnUuid) {
            this.getInfoUUID();
        }
        this.clientOpeners.clear();
        input.method_71426("LootrOpeners", class_4844.field_47491).map(this.clientOpeners::addAll);
        if (input.method_71433("isCustomInventory", false)) {
            if (this.referenceInventory == null) {
                this.referenceInventory = class_2371.method_10213((int)this.getInfoContainerSize(), (Object)class_1799.field_8037);
            }
            class_1262.method_5429((class_11368)input, this.referenceInventory);
        }
    }

    public void saveAdditional(class_11372 output, boolean isClientSide) {
        if (!LootrAPI.shouldDiscard() && !this.providesOwnUuid) {
            output.method_71468("LootrId", class_4844.field_25122, (Object)this.getInfoUUID());
        }
        output.method_71472("LootrHasBeenOpened", this.hasBeenOpened);
        if (isClientSide && !this.clientOpeners.isEmpty()) {
            output.method_71468("LootrOpeners", class_4844.field_47491, this.clientOpeners);
        }
        if (this.referenceInventory != null) {
            output.method_71472("isCustomInventory", true);
            class_1262.method_5426((class_11372)output, this.referenceInventory);
        } else {
            output.method_71472("isCustomInventory", false);
        }
    }

    public class_2487 fillUpdateTag(class_7225.class_7874 provider, boolean isClientSide, class_2586 parent) {
        try (class_8942.class_11340 p = new class_8942.class_11340(LOGGER);){
            class_8942 p2 = p.method_54946(parent.method_71402());
            class_11362 output = class_11362.method_71459((class_8942)p2, (class_7225.class_7874)provider);
            this.saveAdditional((class_11372)output, isClientSide);
            if (!isClientSide) {
                Sets.SetView currentOpeners = Sets.intersection(this.visualOpenersSupplier.get(), LootrAPI.getPlayerIds());
                output.method_71468("LootrOpeners", class_4844.field_47491, (Object)currentOpeners);
            } else {
                LootrAPI.LOG.error("Tried to fillUpdateTag on the client side for SimpleLootrInstance: {}", (Object)this);
            }
            class_2487 class_24872 = output.method_71475();
            return class_24872;
        }
    }

    public boolean isReferenceInventory() {
        return this.referenceInventory != null && !this.referenceInventory.isEmpty();
    }
}

